#version 300 es

precision highp float;

out vec4 out_Color;

in vec2 pass_textureCoords;

uniform sampler2D modelTexture0;

const float width = 0.5;
const float edge = 0.11;

uniform vec3 color;

float smoothlyStep(float edge0, float edge1, float x){
    float t = clamp((x - edge0) / (edge1 - edge0), 0.0, 1.0);
    return t * t * (3.0 - 2.0 * t);
}

void main(void) {
	float distance = 1.0 - texture(modelTexture0, pass_textureCoords).a;
	float alpha = 1.0 - smoothlyStep(width, width + edge, distance);
	
	out_Color = vec4(color, alpha);
}
