#version 300 es

precision highp float;

in vec3 position;
in vec2 textureCoords;

uniform mat4 projectionMatrix;
uniform mat4 transformationMatrix;
uniform mat4 viewMatrix;

out float vFragDepth;
const float nearDepth = 1.0e-6;

const float radius = 695510.0;


uniform float distance;

out vec2 pass_textureCoords;

uniform float diameter;
uniform float temperature;

float calculateGlowSize(float diameter, float temperature, float distance) {
    const float DSUN = 1392684.0;
    const float TSUN = 5778.0;

    // Georg's magic formula
    float d = distance; // Distance
    float D = diameter * DSUN;
    float L = (D * D) * pow(temperature / TSUN, 4.0); // Luminosity
    return 0.016 * pow(L, 0.25) / pow(d, 0.5); // Size
}



out vec2 fPosition;


void main(void) {
	pass_textureCoords = textureCoords;

	float size = calculateGlowSize(diameter, temperature, distance);
	vec3 position2 = vec3(viewMatrix[3][0], viewMatrix[3][1], viewMatrix[3][2]);


	gl_Position = projectionMatrix * viewMatrix * transformationMatrix * vec4(0.0, 0.0, 0.0, 1.0);

	float glZ = gl_Position.w;

    gl_Position /= gl_Position.w;
    // Move the vertex in screen space.
    gl_Position.xy += position.xy * vec2(size, size * 1.7777);

    fPosition = position.xy;

    if(glZ < 0.0) {
    	gl_Position.w = -1.0;
    }

	float Fcoef = 2.0 / log2(1000000000.0 + 1.0);
	gl_Position.z = log2(max(nearDepth, 1.0 + gl_Position.w)) * Fcoef - 1.0;

	vFragDepth = 1.0 + gl_Position.w;
}
