#version 300 es

precision highp float;

in vec3 position;
in vec3 normals;
in vec2 textureCoords;

out vec2 pass_textureCoords;

uniform mat4 projectionMatrix;
uniform mat4 transformationMatrix;
uniform mat4 viewMatrix;

out vec3 pass_normal;

out float vFragDepth;
const float nearDepth = 1.0e-6;

void main(void) {
	pass_normal = normals;
	pass_textureCoords = textureCoords;

	gl_Position = projectionMatrix * viewMatrix * transformationMatrix * vec4(position, 1.0);
	
	float Fcoef = 2.0 / log2(1000000000.0 + 1.0);
	gl_Position.z = log2(max(nearDepth, 1.0 + gl_Position.w)) * Fcoef - 1.0;
	
	vFragDepth = 1.0 + gl_Position.w;
}
