#version 300 es

precision highp float;

out vec4 out_Color;

in float vFragDepth;

in vec3 pass_normal;
in vec2 pass_textureCoords;

uniform vec3 objectPosition;

uniform mat4 transformationMatrix;
uniform sampler2D modelTexture0;

void main(void) {
	vec3 sunIntensity = vec3(1.0, 1.0, 1.0);
	vec3 sunPosition = vec3(0.0, 0.0, 0.0);
	vec3 sunDirection = normalize(sunPosition - objectPosition);
	
	vec3 normal = (transformationMatrix * vec4(pass_normal, 0.0)).xyz;

	vec3 lightIntensity = max(sunIntensity * dot(sunDirection, normal), 0.0);

	out_Color = texture(modelTexture0, pass_textureCoords) * vec4(lightIntensity, 1.0);
	
	float Fcoef = 2.0 / log2(1000000000.0 + 1.0);
	gl_FragDepth = log2(vFragDepth) * (Fcoef / 2.0);
}
