#version 300 es

precision highp float;

out vec4 out_Color;

in float vFragDepth;

in vec3 pass_position;
uniform sampler2D modelTexture0;
uniform sampler2D modelTexture1;

in vec3 c0;
in vec3 c1;

in vec3 surfaceNormal;
in vec3 toLightVector;
in vec3 toCameraVector;

const float PI = 3.141592653589;
const float invHalfPI = 1.0 / PI * 0.5;
const float invPI = 1.0 / PI;

void main(void) {
	float shineDamper = 100.0;
	
	float u = (atan(pass_position.x, pass_position.z) + PI) * invHalfPI;
	float v = (acos(pass_position.y / length(pass_position)) + PI) * invPI  - 1.0;
	vec2 textureCoords = vec2(u, v);

	vec3 lightIntensity = vec3(2.0, 2.0, 2.0);

	vec3 unitNormal = normalize(surfaceNormal);
	vec3 unitLightVector = normalize(toLightVector);
	
	float nDotl = dot(unitNormal, unitLightVector);
	float brightness = max(nDotl, 0.0);
	vec3 diffuse = brightness * lightIntensity;
	
	vec3 unitVectorToCamera = normalize(toCameraVector);
	vec3 lightDirection = -unitLightVector;
	vec3 reflectedLightDirection = reflect(lightDirection, unitNormal);
	
	float specularFactor = dot(reflectedLightDirection, unitVectorToCamera);
	specularFactor = max(specularFactor, 0.0);
	float dampedFactor = pow(specularFactor, shineDamper);
	vec3 finalSpecular = dampedFactor * texture(modelTexture1, textureCoords).x * lightIntensity;
	
	vec3 day = (texture(modelTexture0, textureCoords).xyz + finalSpecular) * c0;

	out_Color = vec4(c1, 1.0) + vec4(day, 1.0);
	
	float Fcoef = 2.0 / log2(1000000000.0 + 1.0);
	gl_FragDepth = log2(vFragDepth) * (Fcoef / 2.0);
}
