#version 300 es

precision highp float;

out vec4 out_Color;

in float vFragDepth;

uniform vec3 v3LightPos;
uniform vec3 objectPosition;
uniform float g;
uniform float g2;
in vec3 v3Direction;
in vec3 c0;
in vec3 c1;

// Calculates the Mie phase function
float getMiePhase(float fCos, float fCos2, float g, float g2) {
	return 1.5 * ((1.0 - g2) / (2.0 + g2)) * (1.0 + fCos2) / pow(1.0 + g2 - 2.0 * g * fCos, 1.5);
}

// Calculates the Rayleigh phase function
float getRayleighPhase(float fCos2) {
	return 0.75 + 0.75 * fCos2;
}

void main(void) {
	vec3 v3LightPosition = normalize(v3LightPos - objectPosition);
	
	float fCos = dot(v3LightPosition, v3Direction) / length(v3Direction);
	float fCos2 = fCos * fCos;
	
	vec3 color = getRayleighPhase(fCos2) * c0 + getMiePhase(fCos, fCos2, g, g2) * c1;

	out_Color = vec4(color, 1.0);
	out_Color.a = out_Color.b;
	
	float Fcoef = 2.0 / log2(1000000000.0 + 1.0);
	gl_FragDepth = log2(vFragDepth) * (Fcoef / 2.0);
}
