#version 300 es

precision highp float;

in vec3 position;

uniform mat4 projectionMatrix;
uniform mat4 transformationMatrix;
uniform mat4 viewMatrix;

out float vFragDepth;
const float nearDepth = 1.0e-6;

out vec3 pass_position;

void main(void) {
	pass_position = position.xyz;

	gl_Position = projectionMatrix * viewMatrix * transformationMatrix * vec4(position, 1.0);
	
	float Fcoef = 2.0 / log2(1000000000.0 + 1.0);
	gl_Position.z = log2(max(nearDepth, 1.0 + gl_Position.w)) * Fcoef - 1.0;

	vFragDepth = 1.0 + gl_Position.w;
}
