#version 300 es

precision highp float;

out vec4 out_Color;
in vec3 pass_position;

in float vFragDepth;

uniform sampler2D modelTexture0;

const float PI = 3.141592653589;
const float invHalfPI = 1.0 / PI * 0.5;
const float invPI = 1.0 / PI;

void main(void) {
	float u = (atan(pass_position.x, pass_position.z) + PI) * invHalfPI;
	float v = (acos(pass_position.y / length(pass_position)) + PI) * invPI  - 1.0;

	out_Color = texture(modelTexture0, vec2(u, v));
	
	float Fcoef = 2.0 / log2(1000000000.0 + 1.0);
	gl_FragDepth = log2(vFragDepth) * (Fcoef / 2.0);
}
