#version 300 es

precision highp float;

in vec3 position;

uniform mat4 projectionMatrix;
uniform mat4 transformationMatrix;
uniform mat4 viewMatrix;

out float vFragDepth;
const float nearDepth = 1.0e-6;

uniform vec3 objectPosition;
uniform float radius;

void main(void) {
	vec3 CameraRight_worldspace = vec3(viewMatrix[0][0], viewMatrix[1][0], viewMatrix[2][0]);
	vec3 CameraUp_worldspace = vec3(viewMatrix[0][1], viewMatrix[1][1], viewMatrix[2][1]);

	vec3 fPosition = (CameraRight_worldspace * position.x + CameraUp_worldspace * position.y);
	
    vec3 vpw = objectPosition + fPosition * radius;

	gl_Position = projectionMatrix * viewMatrix * vec4(vpw, 1.0);
	
	float Fcoef = 2.0 / log2(1000000000.0 + 1.0);
	gl_Position.z = log2(max(nearDepth, 1.0 + gl_Position.w)) * Fcoef - 1.0;

	vFragDepth = 1.0 + gl_Position.w;
}
