/*
 * Decompiled with CFR 0.152.
 */
package Space;

import Camera.Camera;
import Main.MainGameLoop;
import Model.Model;
import Model.Query;
import Physics.GraviationalObject;
import Shader.Shader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;
import org.lwjgl.util.vector.Vector3f;

public class Star {
    private Model billboard;
    private Model billboard1;
    private Model billboard2;
    private Query occlusionQuery;
    private Query query;
    private int visibleSamples = 0;
    private int samples = 0;
    public GraviationalObject star;
    private float radius;
    public float temperature;
    public Vector3f position = new Vector3f();
    public static List<Star> stars = new ArrayList<Star>();
    private Camera camera;
    float[] vertices = new float[]{-1.0f, 1.0f, 0.0f, -1.0f, -1.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f, 1.0f, 0.0f};
    int[] indices;
    float[] textureCoords;
    private static float starTime = 0.0f;
    private static Shader starShader = new Shader("src/Shader/starShader.vs.glsl", "src/Shader/starShader.fs.glsl", new String[]{"modelTexture0", "time", "temperature", "radius"}, false);
    private static Shader starBillboardShader = new Shader("src/Shader/starBillboardShader.vs.glsl", "src/Shader/starBillboardShader.fs.glsl", new String[]{"time", "modelTexture0", "temperature", "objectPosition", "radius"}, false);
    private static Shader queryOcclusionShader = new Shader("src/Shader/queryOcclusionShader.vs.glsl", "src/Shader/queryOcclusionShader.fs.glsl", new String[]{"objectPosition", "radius"}, false);
    private static Shader starFixedBillboardShader = new Shader("src/Shader/starFixedBillboardShader.vs.glsl", "src/Shader/starFixedBillboardShader.fs.glsl", new String[]{"modelTexture0", "time", "starBrightness", "temperature", "distance", "diameter"}, false);

    public Star(float radius, float temperature, double mass, Camera camera) {
        int[] nArray = new int[6];
        nArray[1] = 1;
        nArray[2] = 3;
        nArray[3] = 3;
        nArray[4] = 1;
        nArray[5] = 2;
        this.indices = nArray;
        this.textureCoords = new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f};
        this.star = new GraviationalObject(5, radius, new String[]{"starSpectrumO"}, mass, starShader);
        this.billboard = new Model(this.vertices, this.indices, new float[0], this.textureCoords, new String[]{"starSpectrumO"}, starBillboardShader);
        this.billboard1 = new Model(this.vertices, this.indices, new float[0], this.textureCoords, new String[]{"starSpectrum"}, starFixedBillboardShader);
        this.billboard2 = new Model(this.vertices, this.indices, new float[0], this.textureCoords, new String[0], queryOcclusionShader);
        this.occlusionQuery = new Query(35092);
        this.query = new Query(35092);
        this.camera = camera;
        this.radius = radius;
        this.temperature = temperature;
        Star.starShader.visible = false;
        Star.starBillboardShader.visible = false;
        Star.queryOcclusionShader.visible = false;
        Star.starFixedBillboardShader.visible = false;
        stars.add(this);
    }

    public static void update() {
        int i = 0;
        while (i < stars.size()) {
            Star.stars.get((int)i).star.positionX = new BigDecimal(Star.stars.get((int)i).position.x);
            Star.stars.get((int)i).star.positionY = new BigDecimal(Star.stars.get((int)i).position.y);
            Star.stars.get((int)i).star.positionZ = new BigDecimal(Star.stars.get((int)i).position.z);
            Star.stars.get((int)i).star.update();
            ++i;
        }
    }

    public static void render(Camera camera) {
        Vector3f normalizePosition;
        GL20.glUseProgram(queryOcclusionShader.getProgram());
        queryOcclusionShader.init(camera);
        GL11.glDepthMask(false);
        GL11.glColorMask(false, false, false, false);
        int i = 0;
        while (i < stars.size()) {
            GL11.glEnable(2929);
            GL20.glUseProgram(queryOcclusionShader.getProgram());
            queryOcclusionShader.loadFloat("radius", Star.stars.get((int)i).radius);
            if (Star.stars.get((int)i).occlusionQuery.isResultReady()) {
                Star.stars.get((int)i).visibleSamples = Star.stars.get((int)i).occlusionQuery.getResult();
            }
            if (!Star.stars.get((int)i).occlusionQuery.isInUse()) {
                Star.stars.get((int)i).occlusionQuery.start();
                normalizePosition = new Vector3f(Star.stars.get((int)i).camera.position.x - Star.stars.get((int)i).position.x, Star.stars.get((int)i).camera.position.y - Star.stars.get((int)i).position.y, Star.stars.get((int)i).camera.position.z - Star.stars.get((int)i).position.z);
                normalizePosition.normalise();
                Vector3f billboard2Position = new Vector3f(normalizePosition);
                billboard2Position.x *= -Star.stars.get((int)i).star.radius * 1.5f;
                billboard2Position.y *= -Star.stars.get((int)i).star.radius * 1.5f;
                billboard2Position.z *= -Star.stars.get((int)i).star.radius * 1.5f;
                Star.stars.get((int)i).billboard2.position.set(billboard2Position);
                Star.stars.get((int)i).billboard2.position.set(Star.stars.get((int)i).position);
                Star.stars.get((int)i).billboard2.update();
                Star.stars.get((int)i).billboard2.render();
                Star.stars.get((int)i).occlusionQuery.end();
            }
            GL11.glDisable(2929);
            if (Star.stars.get((int)i).query.isResultReady()) {
                Star.stars.get((int)i).samples = Star.stars.get((int)i).query.getResult();
            }
            if (!Star.stars.get((int)i).query.isInUse()) {
                Star.stars.get((int)i).query.start();
                GL20.glUseProgram(queryOcclusionShader.getProgram());
                Star.stars.get((int)i).billboard2.render();
                Star.stars.get((int)i).query.end();
            }
            ++i;
        }
        GL11.glColorMask(true, true, true, true);
        GL11.glDepthMask(true);
        GL11.glEnable(2929);
        GL20.glUseProgram(starShader.getProgram());
        starShader.init(camera);
        i = 0;
        while (i < stars.size()) {
            starShader.loadFloat("time", starTime);
            starShader.loadFloat("temperature", Star.stars.get((int)i).temperature);
            starShader.loadFloat("radius", Star.stars.get((int)i).radius);
            Star.stars.get((int)i).star.positionX = new BigDecimal(Star.stars.get((int)i).position.x);
            Star.stars.get((int)i).star.positionY = new BigDecimal(Star.stars.get((int)i).position.y);
            Star.stars.get((int)i).star.positionZ = new BigDecimal(Star.stars.get((int)i).position.z);
            Star.stars.get((int)i).star.model.update();
            Star.stars.get((int)i).star.model.render();
            ++i;
        }
        GL11.glBlendFunc(770, 1);
        GL20.glUseProgram(starBillboardShader.getProgram());
        starBillboardShader.init(camera);
        i = 0;
        while (i < stars.size()) {
            starBillboardShader.loadFloat("time", starTime += MainGameLoop.delta_time / 100.0f);
            starBillboardShader.loadFloat("temperature", Star.stars.get((int)i).temperature);
            starBillboardShader.loadFloat("radius", Star.stars.get((int)i).radius);
            Star.stars.get((int)i).billboard.position.set(Star.stars.get((int)i).position);
            Star.stars.get((int)i).billboard.update();
            Star.stars.get((int)i).billboard.render();
            ++i;
        }
        GL11.glDisable(2929);
        GL20.glUseProgram(starFixedBillboardShader.getProgram());
        starFixedBillboardShader.init(camera);
        i = 0;
        while (i < stars.size()) {
            normalizePosition = new Vector3f(-Star.stars.get((int)i).camera.position.x - Star.stars.get((int)i).position.x, -Star.stars.get((int)i).camera.position.y - Star.stars.get((int)i).position.y, -Star.stars.get((int)i).camera.position.z - Star.stars.get((int)i).position.z);
            float length = new Vector3f(-camera.position.x - Star.stars.get((int)i).position.x, -camera.position.y - Star.stars.get((int)i).position.y, -camera.position.z - Star.stars.get((int)i).position.z).length();
            normalizePosition.normalise();
            float positionLength = normalizePosition.x + normalizePosition.y + normalizePosition.z;
            starFixedBillboardShader.loadFloat("time", positionLength * 0.3f);
            starFixedBillboardShader.loadFloat("starBrightness", (float)Star.stars.get((int)i).visibleSamples / (float)Star.stars.get((int)i).samples);
            starFixedBillboardShader.loadFloat("temperature", Star.stars.get((int)i).temperature);
            starFixedBillboardShader.loadFloat("distance", length);
            starFixedBillboardShader.loadFloat("diameter", Star.stars.get((int)i).radius * 2.0f);
            Star.stars.get((int)i).billboard1.position.set(Star.stars.get((int)i).position);
            Star.stars.get((int)i).billboard1.update();
            Star.stars.get((int)i).billboard1.render();
            ++i;
        }
        GL11.glBlendFunc(770, 771);
    }
}

