/*
 * Decompiled with CFR 0.152.
 */
package Shader;

import Camera.Camera;
import Model.GUI;
import Model.Model;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL20;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector3f;

public class Shader {
    private int projectionUniformMatrixId;
    private int viewUniformMatrixId;
    public int transformationUniformMatrixId;
    private FloatBuffer matrixBuffer = BufferUtils.createFloatBuffer(16);
    public Map<String, Integer> uniformIds = new HashMap<String, Integer>();
    private int programId;
    private List<Model> models = new ArrayList<Model>();
    private List<GUI> gui = new ArrayList<GUI>();
    public static List<Shader> shaders = new ArrayList<Shader>();
    public boolean ui;
    public boolean visible = true;

    private void push(Shader push) {
        shaders.add(push);
    }

    public void pushModel(Model push) {
        this.models.add(push);
    }

    public void pushGUI(GUI push) {
        this.gui.add(push);
    }

    public static Vector3f Color(int hex) {
        float r = (float)(hex >> 16 & 0xFF) / 255.0f;
        float g = (float)(hex >> 8 & 0xFF) / 255.0f;
        float b = (float)(hex & 0xFF) / 255.0f;
        return new Vector3f(r, g, b);
    }

    private int createShader(int type, String path) {
        StringBuilder source = new StringBuilder();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(path));
            while ((line = reader.readLine()) != null) {
                source.append(line).append("//\n");
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        int shader = GL20.glCreateShader(type);
        GL20.glShaderSource(shader, source);
        GL20.glCompileShader(shader);
        if (GL20.glGetShaderi(shader, 35713) == 0) {
            System.out.println(GL20.glGetShaderInfoLog(shader, 500));
            System.err.println("Could not compile shader!");
            GL20.glDeleteShader(shader);
            System.exit(-1);
        }
        return shader;
    }

    private int createProgram(int vertexShader, int fragmentShader) {
        int program = GL20.glCreateProgram();
        GL20.glAttachShader(program, vertexShader);
        GL20.glAttachShader(program, fragmentShader);
        GL20.glLinkProgram(program);
        if (GL20.glGetProgrami(program, 35713) == 0) {
            System.out.println(GL20.glGetProgramInfoLog(program, 500));
            System.err.println("Could not compile shader!");
            GL20.glDeleteProgram(program);
            System.exit(-1);
        }
        return program;
    }

    public Shader(String vertexShaderPath, String fragmentShaderPath, String[] uniformNames, boolean ui) {
        int vertexShader = this.createShader(35633, vertexShaderPath);
        int fragmentShader = this.createShader(35632, fragmentShaderPath);
        this.programId = this.createProgram(vertexShader, fragmentShader);
        this.ui = ui;
        this.push(this);
        GL20.glUseProgram(this.programId);
        int i = 0;
        while (i < uniformNames.length) {
            this.uniformIds.put(uniformNames[i], GL20.glGetUniformLocation(this.programId, uniformNames[i]));
            ++i;
        }
        this.viewUniformMatrixId = GL20.glGetUniformLocation(this.programId, "viewMatrix");
        this.projectionUniformMatrixId = GL20.glGetUniformLocation(this.programId, "projectionMatrix");
        this.transformationUniformMatrixId = GL20.glGetUniformLocation(this.programId, "transformationMatrix");
    }

    public void loadMatrix(int location, Matrix4f matrix) {
        matrix.store(this.matrixBuffer);
        this.matrixBuffer.flip();
        GL20.glUniformMatrix4(location, false, this.matrixBuffer);
    }

    public void loadFloat(String name, float value) {
        int location = this.uniformIds.get(name);
        GL20.glUniform1f(location, value);
    }

    public void loadVector(String name, Vector3f vector) {
        int location = this.uniformIds.get(name);
        GL20.glUniform3f(location, vector.x, vector.y, vector.z);
    }

    public void loadBoolean(String name, boolean value) {
        int location = this.uniformIds.get(name);
        float toLoad = 0.0f;
        if (value) {
            toLoad = 1.0f;
        }
        GL20.glUniform1f(location, toLoad);
    }

    public int getProgram() {
        return this.programId;
    }

    public void init(Camera camera) {
        this.loadMatrix(this.projectionUniformMatrixId, camera.projectionMatrix);
        this.loadMatrix(this.viewUniformMatrixId, camera.viewMatrix);
    }

    public void render(Camera camera) {
        GL20.glUseProgram(this.programId);
        this.init(camera);
        int i = 0;
        while (i < this.models.size()) {
            if (this.models.get((int)i).visible) {
                this.models.get(i).update();
                this.models.get(i).render();
            }
            ++i;
        }
    }

    public void guiRender() {
        GL20.glUseProgram(this.programId);
        int i = 0;
        while (i < this.gui.size()) {
            this.gui.get(i).render();
            ++i;
        }
    }
}

