/*
 * Decompiled with CFR 0.152.
 */
package Physics;

import Geometry.Icosphere;
import Main.MainGameLoop;
import Model.Model;
import Physics.Gravity;
import Shader.Shader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.util.vector.Vector3f;

public class GraviationalObject {
    public static List<GraviationalObject> objectArray = new ArrayList<GraviationalObject>();
    public double mass;
    public Model model;
    public Vector3f position;
    public Vector3f rotation;
    public Vector3f rotationalVelocity;
    public BigDecimal positionX = new BigDecimal(0);
    public BigDecimal positionY = new BigDecimal(0);
    public BigDecimal positionZ = new BigDecimal(0);
    public BigDecimal velocityX = new BigDecimal(0);
    public BigDecimal velocityY = new BigDecimal(0);
    public BigDecimal velocityZ = new BigDecimal(0);
    public float radius;

    public GraviationalObject(int subdivisions, float radius, String[] names, double mass, Shader shader) {
        Icosphere geometry = new Icosphere(subdivisions, radius);
        this.model = new Model(geometry.vertices, geometry.indices, geometry.normals, geometry.uv, names, shader);
        this.radius = radius;
        Gravity.push(this);
        this.position = new Vector3f();
        this.rotation = new Vector3f();
        this.rotationalVelocity = new Vector3f();
        this.mass = mass;
        objectArray.add(this);
    }

    public void update() {
        this.positionX = this.positionX.add(this.velocityX.multiply(new BigDecimal(MainGameLoop.delta_time)).multiply(new BigDecimal(MainGameLoop.calculationSpeed)));
        this.positionY = this.positionY.add(this.velocityY.multiply(new BigDecimal(MainGameLoop.delta_time)).multiply(new BigDecimal(MainGameLoop.calculationSpeed)));
        this.positionZ = this.positionZ.add(this.velocityZ.multiply(new BigDecimal(MainGameLoop.delta_time)).multiply(new BigDecimal(MainGameLoop.calculationSpeed)));
        this.position.x = this.positionX.floatValue();
        this.position.y = this.positionY.floatValue();
        this.position.z = this.positionZ.floatValue();
        this.rotation.x = (float)((double)this.rotation.x + (double)(this.rotationalVelocity.x * MainGameLoop.delta_time * MainGameLoop.calculationSpeed * 2.0f) * Math.PI);
        this.rotation.y = (float)((double)this.rotation.y + (double)(this.rotationalVelocity.y * MainGameLoop.delta_time * MainGameLoop.calculationSpeed * 2.0f) * Math.PI);
        this.rotation.z = (float)((double)this.rotation.z + (double)(this.rotationalVelocity.z * MainGameLoop.delta_time * MainGameLoop.calculationSpeed * 2.0f) * Math.PI);
        this.model.position.set(this.position.x, this.position.y, this.position.z);
        this.model.rotation.set(this.rotation.x, this.rotation.y, this.rotation.z);
    }
}

