/*
 * Decompiled with CFR 0.152.
 */
package Model;

import Model.GUI;
import Shader.Shader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.util.vector.Vector2f;
import org.lwjgl.util.vector.Vector3f;

public class Rectangle {
    private static List<GUI> rectangles = new ArrayList<GUI>();
    private static List<Vector2f> sizes = new ArrayList<Vector2f>();
    private static List<Object[]> unifromArray = new ArrayList<Object[]>();
    private static List<Object[]> unifromHoverArray = new ArrayList<Object[]>();
    private static List<Float> interpolationTimes = new ArrayList<Float>();
    private static List<Long> hoverTimes = new ArrayList<Long>();
    private static List<Long> leaveTimes = new ArrayList<Long>();

    public static GUI createRectangle(Vector2f size, int color, float alpha, int hoverColor, float hoverAlpha, float interpolationTime, Shader shader) {
        size.x *= 2.0f;
        size.y *= 2.0f;
        float[] vertices = new float[]{0.0f, 0.0f, 0.0f, -size.y, size.x, -size.y, size.x, -size.y, size.x, 0.0f, 0.0f, 0.0f};
        float[] textureCoords = new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f};
        Object[] uniforms = new Object[]{Shader.Color(color), Float.valueOf(alpha)};
        GUI gui = new GUI(vertices, textureCoords, new String[0], new String[]{"color", "alpha"}, uniforms, shader);
        rectangles.add(gui);
        unifromArray.add(uniforms);
        interpolationTimes.add(Float.valueOf(interpolationTime));
        unifromHoverArray.add(new Object[]{Shader.Color(hoverColor), Float.valueOf(hoverAlpha)});
        sizes.add(size);
        hoverTimes.add(null);
        leaveTimes.add(null);
        return gui;
    }

    public static Vector3f linearInterpolation(Vector3f a, Vector3f b, float x) {
        float ax = Rectangle.linearInterpolation(a.x, b.x, x);
        float ay = Rectangle.linearInterpolation(a.y, b.y, x);
        float az = Rectangle.linearInterpolation(a.z, b.z, x);
        return new Vector3f(ax, ay, az);
    }

    public static float linearInterpolation(float a, float b, float x) {
        return (b - a) * x + a;
    }

    public static void update() {
        float x = 2.0f * (float)Mouse.getX() / (float)Display.getWidth() - 1.0f;
        float y = 2.0f * (float)Mouse.getY() / (float)Display.getHeight() - 1.0f;
        int i = 0;
        while (i < rectangles.size()) {
            Object[] uniformAnswers;
            float ux;
            ArrayList<Serializable> newUniformAnswers;
            float sizeY = Rectangle.sizes.get((int)i).y * ((float)Display.getWidth() / (float)Display.getHeight());
            if (x >= Rectangle.rectangles.get((int)i).position.x && x <= Rectangle.rectangles.get((int)i).position.x + Rectangle.sizes.get((int)i).x && -y >= -Rectangle.rectangles.get((int)i).position.y && -y <= -Rectangle.rectangles.get((int)i).position.y + sizeY) {
                if (hoverTimes.get(i) == null) {
                    hoverTimes.set(i, System.currentTimeMillis());
                }
                newUniformAnswers = new ArrayList();
                ux = (float)(System.currentTimeMillis() - hoverTimes.get(i)) / (interpolationTimes.get(i).floatValue() * 1000.0f);
                if (ux > 1.0f) {
                    ux = 1.0f;
                }
                int n = 0;
                while (n < unifromArray.get(i).length) {
                    if (unifromArray.get(i)[n] instanceof Vector3f) {
                        newUniformAnswers.add(Rectangle.linearInterpolation((Vector3f)unifromArray.get(i)[n], (Vector3f)unifromHoverArray.get(i)[n], ux));
                    } else if (unifromArray.get(i)[n] instanceof Float) {
                        newUniformAnswers.add(Float.valueOf(Rectangle.linearInterpolation(((Float)unifromArray.get(i)[n]).floatValue(), ((Float)unifromHoverArray.get(i)[n]).floatValue(), ux)));
                    }
                    ++n;
                }
                uniformAnswers = newUniformAnswers.toArray();
                Rectangle.rectangles.get((int)i).uniformAnswers = uniformAnswers;
                leaveTimes.set(i, null);
            } else {
                if (leaveTimes.get(i) == null) {
                    leaveTimes.set(i, System.currentTimeMillis());
                }
                newUniformAnswers = new ArrayList<Serializable>();
                ux = (float)(System.currentTimeMillis() - leaveTimes.get(i)) / (interpolationTimes.get(i).floatValue() * 1000.0f);
                if (ux > 1.0f) {
                    ux = 1.0f;
                }
                ux = 1.0f - ux;
                int n = 0;
                while (n < unifromArray.get(i).length) {
                    if (unifromArray.get(i)[n] instanceof Vector3f) {
                        newUniformAnswers.add(Rectangle.linearInterpolation((Vector3f)unifromArray.get(i)[n], (Vector3f)unifromHoverArray.get(i)[n], ux));
                    } else if (unifromArray.get(i)[n] instanceof Float) {
                        newUniformAnswers.add(Float.valueOf(Rectangle.linearInterpolation(((Float)unifromArray.get(i)[n]).floatValue(), ((Float)unifromHoverArray.get(i)[n]).floatValue(), ux)));
                    }
                    ++n;
                }
                uniformAnswers = newUniformAnswers.toArray();
                Rectangle.rectangles.get((int)i).uniformAnswers = uniformAnswers;
                hoverTimes.set(i, null);
            }
            ++i;
        }
    }
}

