/*
 * Decompiled with CFR 0.152.
 */
package Model;

import Shader.Shader;
import java.io.FileInputStream;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector3f;
import org.newdawn.slick.opengl.Texture;
import org.newdawn.slick.opengl.TextureLoader;

public class Model {
    private int vaoId;
    private int indicesBuffer;
    private int indicesLength;
    private Matrix4f pitch;
    private Matrix4f yaw;
    private Matrix4f roll;
    private Matrix4f totalRotation;
    private Matrix4f translationMatrix;
    public Matrix4f transformationMatrix;
    public Vector3f position;
    public Vector3f rotation;
    public Vector3f velocity;
    public boolean visible = true;
    public int frontFace = 2304;
    private Shader shader;
    private int[] textures;

    private IntBuffer storeDataInIntBuffer(int[] data) {
        IntBuffer buffer = BufferUtils.createIntBuffer(data.length);
        buffer.put(data);
        buffer.flip();
        return buffer;
    }

    private FloatBuffer storeDataInFloatBuffer(float[] data) {
        FloatBuffer buffer = BufferUtils.createFloatBuffer(data.length);
        buffer.put(data);
        buffer.flip();
        return buffer;
    }

    private int loadTexture(String fileName) {
        Texture texture = null;
        try {
            texture = TextureLoader.getTexture("PNG", new FileInputStream("res/" + fileName + ".png"));
            GL30.glGenerateMipmap(3553);
            GL11.glTexParameteri(3553, 10241, 9985);
            GL11.glTexParameterf(3553, 34049, -0.6f);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Tried to load texture " + fileName + ".png , didn't work");
            System.exit(-1);
        }
        return texture.getTextureID();
    }

    public Model(float[] vertices, int[] indices, float[] normals, float[] textureCoords, String[] texturePaths, Shader shaderProvided) {
        int positionAttributeLocation = GL20.glGetAttribLocation(shaderProvided.getProgram(), "position");
        this.textures = new int[texturePaths.length];
        int i = 0;
        while (i < texturePaths.length) {
            this.textures[i] = this.loadTexture(texturePaths[i]);
            ++i;
        }
        this.shader = shaderProvided;
        this.indicesLength = indices.length;
        this.position = new Vector3f();
        this.rotation = new Vector3f();
        this.velocity = new Vector3f();
        this.pitch = new Matrix4f();
        this.yaw = new Matrix4f();
        this.roll = new Matrix4f();
        this.totalRotation = new Matrix4f();
        this.transformationMatrix = new Matrix4f();
        int positionBuffer = GL15.glGenBuffers();
        GL15.glBindBuffer(34962, positionBuffer);
        GL15.glBufferData(34962, this.storeDataInFloatBuffer(vertices), 35044);
        this.vaoId = GL30.glGenVertexArrays();
        GL30.glBindVertexArray(this.vaoId);
        GL20.glEnableVertexAttribArray(positionAttributeLocation);
        GL20.glVertexAttribPointer(positionAttributeLocation, 3, 5126, false, 0, 0L);
        this.indicesBuffer = GL15.glGenBuffers();
        GL15.glBindBuffer(34963, this.indicesBuffer);
        GL15.glBufferData(34963, this.storeDataInIntBuffer(indices), 35044);
        int normalBuffer = GL15.glGenBuffers();
        GL15.glBindBuffer(34962, normalBuffer);
        GL15.glBufferData(34962, this.storeDataInFloatBuffer(normals), 35044);
        GL15.glBindBuffer(34962, normalBuffer);
        int normalAttribLocation = GL20.glGetAttribLocation(this.shader.getProgram(), "normals");
        GL20.glVertexAttribPointer(normalAttribLocation, 3, 5126, false, 0, 0L);
        GL20.glEnableVertexAttribArray(normalAttribLocation);
        int textureBuffer = GL15.glGenBuffers();
        GL15.glBindBuffer(34962, textureBuffer);
        GL15.glBufferData(34962, this.storeDataInFloatBuffer(textureCoords), 35044);
        GL15.glBindBuffer(34962, textureBuffer);
        int textureAttribLocation = GL20.glGetAttribLocation(this.shader.getProgram(), "textureCoords");
        GL20.glVertexAttribPointer(textureAttribLocation, 2, 5126, false, 0, 0L);
        GL20.glEnableVertexAttribArray(textureAttribLocation);
        this.shader.pushModel(this);
    }

    public void update() {
        this.pitch = new Matrix4f();
        this.yaw = new Matrix4f();
        this.roll = new Matrix4f();
        this.translationMatrix = new Matrix4f();
        Matrix4f.rotate(this.rotation.x, new Vector3f(1.0f, 0.0f, 0.0f), this.pitch, this.pitch);
        Matrix4f.rotate(this.rotation.y, new Vector3f(0.0f, 1.0f, 0.0f), this.yaw, this.yaw);
        Matrix4f.rotate(this.rotation.z, new Vector3f(0.0f, 0.0f, 1.0f), this.roll, this.roll);
        Matrix4f.translate(this.position, this.translationMatrix, this.translationMatrix);
        Matrix4f.mul(this.pitch, this.yaw, this.totalRotation);
        Matrix4f.mul(this.totalRotation, this.roll, this.totalRotation);
        Matrix4f.mul(this.translationMatrix, this.totalRotation, this.transformationMatrix);
    }

    public void render() {
        this.shader.loadMatrix(this.shader.transformationUniformMatrixId, this.transformationMatrix);
        int i = 0;
        while (i < this.textures.length) {
            GL20.glUniform1i(this.shader.uniformIds.get("modelTexture" + i), i);
            GL13.glActiveTexture(33984 + i);
            GL11.glBindTexture(3553, this.textures[i]);
            ++i;
        }
        try {
            GL20.glUniform3f(this.shader.uniformIds.get("objectPosition"), this.position.x, this.position.y, this.position.z);
        }
        catch (Exception exception) {
            // empty catch block
        }
        GL11.glFrontFace(this.frontFace);
        GL30.glBindVertexArray(this.vaoId);
        GL15.glBindBuffer(34963, this.indicesBuffer);
        GL11.glDrawElements(4, this.indicesLength, 5125, 0L);
    }
}

