/*
 * Decompiled with CFR 0.152.
 */
package Model;

import Shader.Shader;
import java.io.FileInputStream;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector3f;
import org.newdawn.slick.opengl.Texture;
import org.newdawn.slick.opengl.TextureLoader;

public class GUI {
    private int vaoId;
    private int verticesLength;
    public Matrix4f transformationMatrix;
    public Vector3f position;
    public int frontFace = 2304;
    private Shader shader;
    private int[] textures;
    public String[] uniformNames;
    public Object[] uniformAnswers;

    private IntBuffer storeDataInIntBuffer(int[] data) {
        IntBuffer buffer = BufferUtils.createIntBuffer(data.length);
        buffer.put(data);
        buffer.flip();
        return buffer;
    }

    private FloatBuffer storeDataInFloatBuffer(float[] data) {
        FloatBuffer buffer = BufferUtils.createFloatBuffer(data.length);
        buffer.put(data);
        buffer.flip();
        return buffer;
    }

    private int loadTexture(String fileName) {
        Texture texture = null;
        try {
            texture = TextureLoader.getTexture("PNG", new FileInputStream("res/" + fileName + ".png"));
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Tried to load texture " + fileName + ".png , didn't work");
            System.exit(-1);
        }
        return texture.getTextureID();
    }

    public GUI(float[] vertices, float[] textureCoords, String[] texturePaths, String[] uniformNames, Object[] uniformAnswers, Shader shaderProvided) {
        int positionAttributeLocation = GL20.glGetAttribLocation(shaderProvided.getProgram(), "position");
        this.textures = new int[texturePaths.length];
        int i = 0;
        while (i < texturePaths.length) {
            this.textures[i] = this.loadTexture(texturePaths[i]);
            ++i;
        }
        this.uniformNames = uniformNames;
        this.uniformAnswers = uniformAnswers;
        shaderProvided.pushGUI(this);
        this.shader = shaderProvided;
        this.verticesLength = vertices.length;
        this.position = new Vector3f();
        this.transformationMatrix = new Matrix4f();
        this.transformationMatrix.setIdentity();
        int positionBuffer = GL15.glGenBuffers();
        GL15.glBindBuffer(34962, positionBuffer);
        GL15.glBufferData(34962, this.storeDataInFloatBuffer(vertices), 35044);
        this.vaoId = GL30.glGenVertexArrays();
        GL30.glBindVertexArray(this.vaoId);
        GL20.glEnableVertexAttribArray(positionAttributeLocation);
        GL20.glVertexAttribPointer(positionAttributeLocation, 2, 5126, false, 0, 0L);
        int textureBuffer = GL15.glGenBuffers();
        GL15.glBindBuffer(34962, textureBuffer);
        GL15.glBufferData(34962, this.storeDataInFloatBuffer(textureCoords), 35044);
        GL15.glBindBuffer(34962, textureBuffer);
        int textureAttribLocation = GL20.glGetAttribLocation(this.shader.getProgram(), "textureCoords");
        GL20.glVertexAttribPointer(textureAttribLocation, 2, 5126, false, 0, 0L);
        GL20.glEnableVertexAttribArray(textureAttribLocation);
    }

    public void render() {
        int i22 = 0;
        while (i22 < this.textures.length) {
            GL20.glUniform1i(this.shader.uniformIds.get("modelTexture" + i22), i22);
            GL13.glActiveTexture(33984 + i22);
            GL11.glBindTexture(3553, this.textures[i22]);
            ++i22;
        }
        try {
            GL20.glUniform3f(this.shader.uniformIds.get("objectPosition"), this.position.x, this.position.y, this.position.z);
        }
        catch (Exception i22) {
            // empty catch block
        }
        int i = 0;
        while (i < this.uniformNames.length) {
            if (this.uniformAnswers[i] instanceof Vector3f) {
                this.shader.loadVector(this.uniformNames[i], (Vector3f)this.uniformAnswers[i]);
            } else if (this.uniformAnswers[i] instanceof Float) {
                this.shader.loadFloat(this.uniformNames[i], ((Float)this.uniformAnswers[i]).floatValue());
            }
            ++i;
        }
        GL30.glBindVertexArray(this.vaoId);
        GL11.glDrawArrays(4, 0, this.verticesLength);
    }
}

