/*
 * Decompiled with CFR 0.152.
 */
package Main;

import Camera.Camera;
import Camera.RayIntersectSphere;
import Camera.ThirdPersonCamera;
import Display.DisplayManager;
import Geometry.Icosphere;
import Model.Model;
import Model.Rectangle;
import Physics.GraviationalObject;
import Physics.Gravity;
import Renderer.Renderer;
import Shader.Shader;
import Space.Star;
import java.math.BigDecimal;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL20;
import org.lwjgl.util.vector.Vector2f;
import org.lwjgl.util.vector.Vector3f;

public class MainGameLoop {
    public static float delta_time;
    public static float calculationSpeed;
    public static float scale;
    private static boolean previousMouseInput;
    private static long mouseUpTime;
    private static int mouseUpObject;

    static {
        calculationSpeed = 1.0f;
        scale = 1000.0f;
        previousMouseInput = false;
        mouseUpTime = 0L;
        mouseUpObject = -1;
    }

    public static void main(String[] args) {
        DisplayManager display = new DisplayManager(1920, 1080);
        Shader skyShader = new Shader("src/Shader/skyBoxShader.vs.glsl", "src/Shader/skyBoxShader.fs.glsl", new String[]{"modelTexture0"}, false);
        Shader nonAtmosphericGroundShader = new Shader("src/Shader/mainShader.vs.glsl", "src/Shader/mainShader.fs.glsl", new String[]{"modelTexture0", "objectPosition"}, false);
        Shader atmosphereShader = new Shader("src/Shader/atmosphereShader.vs.glsl", "src/Shader/atmosphereShader.fs.glsl", new String[]{"objectPosition", "v3LightPos", "cameraPosition", "v3InvWavelength", "fCameraHeight", "fCameraHeight2", "fOuterRadius", "fOuterRadius2", "fInnerRadius", "fInnerRadius2", "fKrESun", "fKmESun", "fKr4PI", "fKm4PI", "fScale", "fScaleDepth", "fScaleOverScaleDepth", "g", "g2"}, false);
        Shader atmosphericGroundShader = new Shader("src/Shader/atmosphericGroundShader.vs.glsl", "src/Shader/atmosphericGroundShader.fs.glsl", new String[]{"objectPosition", "v3LightPos", "cameraPosition", "v3InvWavelength", "fCameraHeight", "fCameraHeight2", "fOuterRadius", "fOuterRadius2", "fInnerRadius", "fInnerRadius2", "fKrESun", "fKmESun", "fKr4PI", "fKm4PI", "fScale", "fScaleDepth", "fScaleOverScaleDepth", "modelTexture0", "modelTexture1"}, false);
        Shader rectangleShader = new Shader("src/Shader/rectangleShader.vs.glsl", "src/Shader/rectangleShader.fs.glsl", new String[]{"objectPosition", "color", "alpha", "aspectRatio"}, true);
        Shader textShader = new Shader("src/Shader/textShader.vs.glsl", "src/Shader/textShader.fs.glsl", new String[]{"objectPosition", "color", "modelTexture0"}, true);
        GL20.glUseProgram(rectangleShader.getProgram());
        rectangleShader.loadFloat("aspectRatio", (float)Display.getWidth() / (float)Display.getHeight());
        Icosphere geometry = new Icosphere(0, 9.0E8f);
        Model skyBox = new Model(geometry.vertices, geometry.indices, geometry.normals, geometry.uv, new String[]{"Stars"}, skyShader);
        skyBox.frontFace = 2305;
        Camera camera = new Camera(75.0f, 1.7777778f, 1.0E-6f, 1.0E9f);
        Star star = new Star(695510.0f, 5778.0f, 1.0E30, camera);
        Star.update();
        GraviationalObject earth = new GraviationalObject(5, 63710.0f, new String[]{"Earth"}, 1.0E23, atmosphericGroundShader);
        earth.positionZ = new BigDecimal(1.73E8);
        earth.update();
        float Kr = 0.0025f;
        float Km = 0.001f;
        float ESun = 20.0f;
        float g = -0.95f;
        float innerRadius = earth.radius;
        float outerRadius = earth.radius + 1000.0f;
        Vector3f waveLength = new Vector3f(0.65f, 0.57f, 0.475f);
        float scaleDepth = 0.25f;
        float PI = (float)Math.PI;
        GL20.glUseProgram(atmosphericGroundShader.getProgram());
        atmosphericGroundShader.loadVector("v3LightPos", new Vector3f(0.0f, 0.0f, -100.0f));
        atmosphericGroundShader.loadVector("v3InvWavelength", new Vector3f(1.0f / (float)Math.pow(waveLength.x, 4.0), 1.0f / (float)Math.pow(waveLength.y, 4.0), 1.0f / (float)Math.pow(waveLength.z, 4.0)));
        atmosphericGroundShader.loadFloat("fInnerRadius", innerRadius);
        atmosphericGroundShader.loadFloat("fInnerRadius2", innerRadius * innerRadius);
        atmosphericGroundShader.loadFloat("fOuterRadius", outerRadius);
        atmosphericGroundShader.loadFloat("fOuterRadius2", outerRadius * outerRadius);
        atmosphericGroundShader.loadFloat("fKrESun", Kr * ESun);
        atmosphericGroundShader.loadFloat("fKmESun", Km * ESun);
        atmosphericGroundShader.loadFloat("fKr4PI", Kr * 4.0f * PI);
        atmosphericGroundShader.loadFloat("fKm4PI", Km * 4.0f * PI);
        atmosphericGroundShader.loadFloat("fScale", 1.0f / (outerRadius - innerRadius));
        atmosphericGroundShader.loadFloat("fScaleDepth", scaleDepth);
        atmosphericGroundShader.loadFloat("fScaleOverScaleDepth", 1.0f / (outerRadius - innerRadius) / scaleDepth);
        geometry = new Icosphere(6, outerRadius);
        Model atmosphere = new Model(geometry.vertices, geometry.indices, geometry.normals, geometry.uv, new String[0], atmosphereShader);
        atmosphere.frontFace = 2305;
        GL20.glUseProgram(atmosphereShader.getProgram());
        atmosphereShader.loadVector("v3LightPos", new Vector3f(0.0f, 0.0f, -100.0f));
        atmosphereShader.loadVector("v3InvWavelength", new Vector3f(1.0f / (float)Math.pow(waveLength.x, 4.0), 1.0f / (float)Math.pow(waveLength.y, 4.0), 1.0f / (float)Math.pow(waveLength.z, 4.0)));
        atmosphereShader.loadFloat("fInnerRadius", innerRadius);
        atmosphereShader.loadFloat("fInnerRadius2", innerRadius * innerRadius);
        atmosphereShader.loadFloat("fOuterRadius", outerRadius);
        atmosphereShader.loadFloat("fOuterRadius2", outerRadius * outerRadius);
        atmosphereShader.loadFloat("fKrESun", Kr * ESun);
        atmosphereShader.loadFloat("fKmESun", Km * ESun);
        atmosphereShader.loadFloat("fKr4PI", Kr * 4.0f * PI);
        atmosphereShader.loadFloat("fKm4PI", Km * 4.0f * PI);
        atmosphereShader.loadFloat("fScale", 1.0f / (outerRadius - innerRadius));
        atmosphereShader.loadFloat("fScaleDepth", scaleDepth);
        atmosphereShader.loadFloat("fScaleOverScaleDepth", 1.0f / (outerRadius - innerRadius) / scaleDepth);
        atmosphereShader.loadFloat("g", g);
        atmosphereShader.loadFloat("g2", g * g);
        ThirdPersonCamera cameraHelper = new ThirdPersonCamera(camera);
        cameraHelper.switchObject(GraviationalObject.objectArray.get(1));
        Renderer renderer = new Renderer();
        long last_time = System.nanoTime();
        Gravity.update();
        while (display.canRun()) {
            long time = System.nanoTime();
            delta_time = (float)(time - last_time) / 1.0E9f;
            if (Display.wasResized()) {
                camera.updateProjectionMatrix((float)Display.getWidth() / (float)Display.getHeight());
            }
            cameraHelper.update();
            float xDistance = -camera.position.x - earth.position.x;
            float yDistance = -camera.position.y - earth.position.y;
            float zDistance = -camera.position.z - earth.position.z;
            float distance = (float)Math.sqrt(xDistance * xDistance + yDistance * yDistance + zDistance * zDistance);
            Vector3f position = new Vector3f(-camera.position.x - earth.position.x, -camera.position.y - earth.position.y, -camera.position.z - earth.position.z);
            GL20.glUseProgram(atmosphericGroundShader.getProgram());
            atmosphericGroundShader.loadVector("cameraPosition", position);
            atmosphericGroundShader.loadFloat("fCameraHeight", distance);
            atmosphericGroundShader.loadFloat("fCameraHeight2", distance * distance);
            GL20.glUseProgram(atmosphereShader.getProgram());
            atmosphereShader.loadVector("cameraPosition", position);
            atmosphereShader.loadFloat("fCameraHeight", distance);
            atmosphereShader.loadFloat("fCameraHeight2", distance * distance);
            atmosphere.position.set(earth.position);
            if (Keyboard.isKeyDown(13)) {
                star.temperature += 2000.0f * delta_time;
            }
            if (Keyboard.isKeyDown(12)) {
                star.temperature -= 2000.0f * delta_time;
            }
            float x = 2.0f * (float)Mouse.getX() / (float)Display.getWidth() - 1.0f;
            float y = 2.0f * (float)Mouse.getY() / (float)Display.getHeight() - 1.0f;
            int objectId = RayIntersectSphere.ray(camera, new Vector2f(x, y));
            if (!Mouse.isButtonDown(0) && previousMouseInput) {
                if (mouseUpTime + 250L > System.currentTimeMillis() && objectId != -1 && mouseUpObject == objectId) {
                    cameraHelper.switchObject(GraviationalObject.objectArray.get(objectId));
                }
                mouseUpTime = System.currentTimeMillis();
                mouseUpObject = objectId;
            }
            previousMouseInput = Mouse.isButtonDown(0);
            Rectangle.update();
            renderer.render(camera);
            Star.render(camera);
            renderer.renderGUI();
            display.update();
            last_time = time;
        }
        display.close();
    }
}

