/*
 * Decompiled with CFR 0.152.
 */
package Geometry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lwjgl.util.vector.Vector2f;
import org.lwjgl.util.vector.Vector3f;

public class Icosphere {
    private static float t = (float)((1.0 + Math.sqrt(5.0)) / 2.0);
    private List<Vector3f> verticesArray = new ArrayList<Vector3f>();
    private List<Integer> facesArray = new ArrayList<Integer>();
    private List<Float> normalArray = new ArrayList<Float>();
    private Map<Long, Integer> middlePointIndexCache = new HashMap<Long, Integer>();
    private static final Vector3f[] ico_vertices = new Vector3f[]{new Vector3f(-1.0f, t, 0.0f), new Vector3f(1.0f, t, 0.0f), new Vector3f(-1.0f, -t, 0.0f), new Vector3f(1.0f, -t, 0.0f), new Vector3f(0.0f, -1.0f, t), new Vector3f(0.0f, 1.0f, t), new Vector3f(0.0f, -1.0f, -t), new Vector3f(0.0f, 1.0f, -t), new Vector3f(t, 0.0f, -1.0f), new Vector3f(t, 0.0f, 1.0f), new Vector3f(-t, 0.0f, -1.0f), new Vector3f(-t, 0.0f, 1.0f)};
    public static final int[] ico_indices;
    public float[] vertices;
    public float[] normals;
    public int[] indices;
    public float[] uv;
    private float radius;
    private int index;

    static {
        int[] nArray = new int[60];
        nArray[1] = 11;
        nArray[2] = 5;
        nArray[4] = 5;
        nArray[5] = 1;
        nArray[7] = 1;
        nArray[8] = 7;
        nArray[10] = 7;
        nArray[11] = 10;
        nArray[13] = 10;
        nArray[14] = 11;
        nArray[15] = 1;
        nArray[16] = 5;
        nArray[17] = 9;
        nArray[18] = 5;
        nArray[19] = 11;
        nArray[20] = 4;
        nArray[21] = 11;
        nArray[22] = 10;
        nArray[23] = 2;
        nArray[24] = 10;
        nArray[25] = 7;
        nArray[26] = 6;
        nArray[27] = 7;
        nArray[28] = 1;
        nArray[29] = 8;
        nArray[30] = 3;
        nArray[31] = 9;
        nArray[32] = 4;
        nArray[33] = 3;
        nArray[34] = 4;
        nArray[35] = 2;
        nArray[36] = 3;
        nArray[37] = 2;
        nArray[38] = 6;
        nArray[39] = 3;
        nArray[40] = 6;
        nArray[41] = 8;
        nArray[42] = 3;
        nArray[43] = 8;
        nArray[44] = 9;
        nArray[45] = 4;
        nArray[46] = 9;
        nArray[47] = 5;
        nArray[48] = 2;
        nArray[49] = 4;
        nArray[50] = 11;
        nArray[51] = 6;
        nArray[52] = 2;
        nArray[53] = 10;
        nArray[54] = 8;
        nArray[55] = 6;
        nArray[56] = 7;
        nArray[57] = 9;
        nArray[58] = 8;
        nArray[59] = 1;
        ico_indices = nArray;
    }

    public Icosphere(int recursionLevel, float radius) {
        this.radius = radius;
        this.index = 0;
        int i = 0;
        while (i < ico_vertices.length) {
            this.addVertex(ico_vertices[i]);
            ++i;
        }
        i = 0;
        while (i < ico_indices.length) {
            this.facesArray.add(ico_indices[i]);
            ++i;
        }
        i = 0;
        while (i < recursionLevel) {
            ArrayList<Integer> faces2 = new ArrayList<Integer>();
            int j = 0;
            while (j < this.facesArray.size()) {
                int v1 = this.facesArray.get(j + 0);
                int v2 = this.facesArray.get(j + 1);
                int v3 = this.facesArray.get(j + 2);
                int a = this.getMiddlePoint(v1, v2);
                int b = this.getMiddlePoint(v2, v3);
                int c = this.getMiddlePoint(v3, v1);
                faces2.add(v1);
                faces2.add(a);
                faces2.add(c);
                faces2.add(v2);
                faces2.add(b);
                faces2.add(a);
                faces2.add(v3);
                faces2.add(c);
                faces2.add(b);
                faces2.add(a);
                faces2.add(b);
                faces2.add(c);
                j += 3;
            }
            this.facesArray = faces2;
            ++i;
        }
        this.vertices = new float[this.verticesArray.size() * 3];
        i = 0;
        while (i < this.verticesArray.size()) {
            this.vertices[i * 3] = this.verticesArray.get((int)i).x;
            this.vertices[i * 3 + 1] = this.verticesArray.get((int)i).y;
            this.vertices[i * 3 + 2] = this.verticesArray.get((int)i).z;
            ++i;
        }
        Vector3f[] vertices2 = new Vector3f[this.verticesArray.size()];
        int i2 = 0;
        while (i2 < this.verticesArray.size()) {
            vertices2[i2] = this.verticesArray.get(i2);
            ++i2;
        }
        this.normals = new float[this.normalArray.size()];
        i2 = 0;
        while (i2 < this.normalArray.size()) {
            this.normals[i2] = this.normalArray.get(i2).floatValue();
            ++i2;
        }
        this.indices = new int[this.facesArray.size()];
        i2 = 0;
        while (i2 < this.indices.length) {
            this.indices[i2] = this.facesArray.get(i2);
            ++i2;
        }
        Vector2f[] texArray = this.getUV(vertices2);
        this.uv = new float[texArray.length * 2];
        int i3 = 0;
        while (i3 < texArray.length) {
            this.uv[i3 * 2] = texArray[i3].x;
            this.uv[i3 * 2 + 1] = texArray[i3].y;
            ++i3;
        }
    }

    private int addVertex(Vector3f p) {
        float length = (float)Math.sqrt(p.x * p.x + p.y * p.y + p.z * p.z);
        p.x /= length;
        p.y /= length;
        p.z /= length;
        this.normalArray.add(Float.valueOf(p.x));
        this.normalArray.add(Float.valueOf(p.y));
        this.normalArray.add(Float.valueOf(p.z));
        p.x *= this.radius;
        p.y *= this.radius;
        p.z *= this.radius;
        this.verticesArray.add(p);
        return this.index++;
    }

    private int getMiddlePoint(int p1, int p2) {
        long greaterIndex;
        boolean firstIsSmaller = p1 < p2;
        long smallerIndex = firstIsSmaller ? p1 : p2;
        long key = (smallerIndex << 32) + (greaterIndex = (long)(firstIsSmaller ? p2 : p1));
        Integer ret = this.middlePointIndexCache.get(key);
        if (ret != null) {
            return ret;
        }
        Vector3f point1 = this.verticesArray.get(p1);
        Vector3f point2 = this.verticesArray.get(p2);
        Vector3f middle = new Vector3f((point1.x + point2.x) / 2.0f, (point1.y + point2.y) / 2.0f, (point1.z + point2.z) / 2.0f);
        int i = this.addVertex(middle);
        this.middlePointIndexCache.put(key, i);
        return i;
    }

    private Vector2f[] getUV(Vector3f[] vertices) {
        int num = vertices.length;
        float invHalfPI = 0.15915494f;
        float invPI = 0.31830987f;
        float PI = (float)Math.PI;
        Vector2f[] UV = new Vector2f[num];
        int i = 0;
        while (i < num) {
            float norm = vertices[i].length();
            float u = (float)((Math.atan2(vertices[i].x, vertices[i].z) + (double)PI) * (double)invHalfPI);
            float v = (float)((Math.acos(vertices[i].y / norm) + (double)PI) * (double)invPI - 1.0);
            UV[i] = new Vector2f();
            UV[i].x = u;
            UV[i].y = v;
            ++i;
        }
        return UV;
    }
}

