/*
 * Decompiled with CFR 0.152.
 */
package Geometry;

import Model.Model;
import Shader.Shader;
import org.lwjgl.util.vector.Vector2f;
import org.lwjgl.util.vector.Vector3f;

public class CubeSphere {
    private float[] vertices;
    private int[] indices;
    private float[] normals;
    private float[] textureCoords;
    public Model[] objects;

    public CubeSphere(int size, float radius, String[] textures, Shader shader) {
        this.vertices = new float[size * size * 3];
        this.indices = new int[(size - 1) * (size - 1) * 6];
        this.normals = new float[size * size * 3];
        this.textureCoords = new float[size * size * 2];
        this.objects = new Model[6];
        Vector3f localUp = new Vector3f(0.0f, 0.0f, 0.0f);
        int n = 0;
        while (n < 6) {
            switch (n) {
                case 0: {
                    localUp = new Vector3f(1.0f, 0.0f, 0.0f);
                    break;
                }
                case 1: {
                    localUp = new Vector3f(0.0f, 1.0f, 0.0f);
                    break;
                }
                case 2: {
                    localUp = new Vector3f(0.0f, 0.0f, 1.0f);
                    break;
                }
                case 3: {
                    localUp = new Vector3f(-1.0f, 0.0f, 0.0f);
                    break;
                }
                case 4: {
                    localUp = new Vector3f(0.0f, -1.0f, 0.0f);
                    break;
                }
                case 5: {
                    localUp = new Vector3f(0.0f, 0.0f, -1.0f);
                }
            }
            Vector3f axisA = new Vector3f(localUp.y, localUp.z, localUp.x);
            Vector3f axisB = new Vector3f(0.0f, 0.0f, 0.0f);
            axisB.x = localUp.y * axisA.z - localUp.z * axisA.y;
            axisB.y = localUp.z * axisA.x - localUp.x * axisA.z;
            axisB.z = localUp.x * axisA.y - localUp.y * axisA.x;
            int x = 0;
            while (x < size) {
                int z = 0;
                while (z < size) {
                    int selector = (x + z * size) * 3;
                    Vector2f percent = new Vector2f(x, z);
                    percent.x /= (float)(size - 1);
                    percent.y /= (float)(size - 1);
                    Vector3f l1 = new Vector3f();
                    l1.x = (percent.x - 0.5f) * 2.0f * axisA.x;
                    l1.y = (percent.x - 0.5f) * 2.0f * axisA.y;
                    l1.z = (percent.x - 0.5f) * 2.0f * axisA.z;
                    Vector3f l2 = new Vector3f();
                    l2.x = (percent.y - 0.5f) * 2.0f * axisB.x;
                    l2.y = (percent.y - 0.5f) * 2.0f * axisB.y;
                    l2.z = (percent.y - 0.5f) * 2.0f * axisB.z;
                    Vector3f pointOnUnitCube = new Vector3f(localUp.x + l1.x + l2.x, localUp.y + l1.y + l2.y, localUp.z + l1.z + l2.z);
                    Vector3f vPosition = new Vector3f(pointOnUnitCube.x, pointOnUnitCube.y, pointOnUnitCube.z);
                    vPosition.normalise();
                    this.vertices[selector] = vPosition.x * radius;
                    this.vertices[selector + 1] = vPosition.y * radius;
                    this.vertices[selector + 2] = vPosition.z * radius;
                    this.normals[selector] = vPosition.x;
                    this.normals[selector + 1] = vPosition.y;
                    this.normals[selector + 2] = vPosition.z;
                    this.textureCoords[(x + z * size) * 2] = (float)z / (float)(size - 1);
                    this.textureCoords[(x + z * size) * 2 + 1] = (float)x / (float)(size - 1);
                    ++z;
                }
                ++x;
            }
            int pointer = 0;
            int x2 = 0;
            while (x2 < size - 1) {
                int z = 0;
                while (z < size - 1) {
                    int selector = x2 + z * size;
                    this.indices[pointer] = selector + size;
                    this.indices[pointer + 1] = selector + 1 + size;
                    this.indices[pointer + 2] = selector + 1;
                    this.indices[pointer + 3] = selector + size;
                    this.indices[pointer + 4] = selector + 1;
                    this.indices[pointer + 5] = selector;
                    pointer += 6;
                    ++z;
                }
                ++x2;
            }
            String[] tempTextures = new String[textures.length];
            int i = 0;
            while (i < tempTextures.length) {
                tempTextures[i] = String.valueOf(textures[i]) + n;
                ++i;
            }
            this.objects[n] = new Model(this.vertices, this.indices, this.normals, this.textureCoords, tempTextures, shader);
            ++n;
        }
    }
}

