/*
 * Decompiled with CFR 0.152.
 */
package FontCreator;

import FontCreator.Character;
import FontCreator.GUIText;
import FontCreator.Line;
import FontCreator.MetaFile;
import FontCreator.TextMeshData;
import FontCreator.Word;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class TextMeshCreator {
    protected static final double LINE_HEIGHT = (double)0.03f;
    protected static final int SPACE_ASCII = 32;
    private MetaFile metaData;

    protected TextMeshCreator(File metaFile1) {
        this.metaData = new MetaFile(metaFile1);
    }

    protected TextMeshData createTextMesh(GUIText text) {
        List<Line> lines = this.createStructure(text);
        TextMeshData data = this.createQuadVertices(text, lines);
        return data;
    }

    private List<Line> createStructure(GUIText text) {
        char[] chars = text.getTextString().toCharArray();
        ArrayList<Line> lines = new ArrayList<Line>();
        Line currentLine = new Line(this.metaData.getSpaceWidth(), text.getFontSize(), text.getMaxLineSize());
        Word currentWord = new Word(text.getFontSize());
        char[] cArray = chars;
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            char ascii = c;
            if (ascii == ' ') {
                boolean added = currentLine.attemptToAddWord(currentWord);
                if (!added) {
                    lines.add(currentLine);
                    currentLine = new Line(this.metaData.getSpaceWidth(), text.getFontSize(), text.getMaxLineSize());
                    currentLine.attemptToAddWord(currentWord);
                }
                currentWord = new Word(text.getFontSize());
            } else {
                Character character = this.metaData.getCharacter(ascii);
                currentWord.addCharacter(character);
            }
            ++n2;
        }
        this.completeStructure(lines, currentLine, currentWord, text);
        return lines;
    }

    private void completeStructure(List<Line> lines, Line currentLine, Word currentWord, GUIText text) {
        boolean added = currentLine.attemptToAddWord(currentWord);
        if (!added) {
            lines.add(currentLine);
            currentLine = new Line(this.metaData.getSpaceWidth(), text.getFontSize(), text.getMaxLineSize());
            currentLine.attemptToAddWord(currentWord);
        }
        lines.add(currentLine);
    }

    private TextMeshData createQuadVertices(GUIText text, List<Line> lines) {
        text.setNumberOfLines(lines.size());
        double curserX = 0.0;
        double curserY = 0.0;
        ArrayList<Float> vertices = new ArrayList<Float>();
        ArrayList<Float> textureCoords = new ArrayList<Float>();
        for (Line line : lines) {
            if (text.isCentered()) {
                curserX = (line.getMaxLength() - line.getLineLength()) / 2.0;
            }
            for (Word word : line.getWords()) {
                for (Character letter : word.getCharacters()) {
                    this.addVerticesForCharacter(curserX, curserY, letter, text.getFontSize(), vertices);
                    TextMeshCreator.addTexCoords(textureCoords, letter.getxTextureCoord(), letter.getyTextureCoord(), letter.getXMaxTextureCoord(), letter.getYMaxTextureCoord());
                    curserX += letter.getxAdvance() * (double)text.getFontSize();
                }
                curserX += this.metaData.getSpaceWidth() * (double)text.getFontSize();
            }
            curserX = 0.0;
            curserY += (double)0.03f * (double)text.getFontSize();
        }
        return new TextMeshData(TextMeshCreator.listToArray(vertices), TextMeshCreator.listToArray(textureCoords));
    }

    private void addVerticesForCharacter(double curserX, double curserY, Character character, double fontSize, List<Float> vertices) {
        double x = curserX + character.getxOffset() * fontSize;
        double y = curserY + character.getyOffset() * fontSize;
        double maxX = x + character.getSizeX() * fontSize;
        double maxY = y + character.getSizeY() * fontSize;
        double properX = 2.0 * x - 1.0;
        double properY = -2.0 * y + 1.0;
        double properMaxX = 2.0 * maxX - 1.0;
        double properMaxY = -2.0 * maxY + 1.0;
        TextMeshCreator.addVertices(vertices, properX, properY, properMaxX, properMaxY);
    }

    private static void addVertices(List<Float> vertices, double x, double y, double maxX, double maxY) {
        vertices.add(Float.valueOf((float)x));
        vertices.add(Float.valueOf((float)y));
        vertices.add(Float.valueOf((float)x));
        vertices.add(Float.valueOf((float)maxY));
        vertices.add(Float.valueOf((float)maxX));
        vertices.add(Float.valueOf((float)maxY));
        vertices.add(Float.valueOf((float)maxX));
        vertices.add(Float.valueOf((float)maxY));
        vertices.add(Float.valueOf((float)maxX));
        vertices.add(Float.valueOf((float)y));
        vertices.add(Float.valueOf((float)x));
        vertices.add(Float.valueOf((float)y));
    }

    private static void addTexCoords(List<Float> texCoords, double x, double y, double maxX, double maxY) {
        texCoords.add(Float.valueOf((float)x));
        texCoords.add(Float.valueOf((float)y));
        texCoords.add(Float.valueOf((float)x));
        texCoords.add(Float.valueOf((float)maxY));
        texCoords.add(Float.valueOf((float)maxX));
        texCoords.add(Float.valueOf((float)maxY));
        texCoords.add(Float.valueOf((float)maxX));
        texCoords.add(Float.valueOf((float)maxY));
        texCoords.add(Float.valueOf((float)maxX));
        texCoords.add(Float.valueOf((float)y));
        texCoords.add(Float.valueOf((float)x));
        texCoords.add(Float.valueOf((float)y));
    }

    private static float[] listToArray(List<Float> listOfFloats) {
        float[] array = new float[listOfFloats.size()];
        int i = 0;
        while (i < array.length) {
            array[i] = listOfFloats.get(i).floatValue();
            ++i;
        }
        return array;
    }
}

