/*
 * Decompiled with CFR 0.152.
 */
package Display;

import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.ContextAttribs;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.PixelFormat;

public class DisplayManager {
    public int width;
    public int height;
    public float aspectRatio;

    public DisplayManager(int WIDTH, int HEIGHT) {
        ContextAttribs attribs = new ContextAttribs(3, 2).withForwardCompatible(true).withProfileCore(true);
        try {
            System.setProperty("org.lwjgl.opengl.Window.undecorated", "true");
            Display.setDisplayMode(new DisplayMode(WIDTH, HEIGHT));
            Display.create(new PixelFormat().withSamples(8), attribs);
            Display.setTitle("Space Game");
            Display.setResizable(true);
            this.width = WIDTH;
            this.height = HEIGHT;
            this.aspectRatio = (float)WIDTH / (float)HEIGHT;
        }
        catch (LWJGLException e) {
            e.printStackTrace();
        }
        GL11.glViewport(0, 0, WIDTH, HEIGHT);
    }

    public void update() {
        if (Display.wasResized()) {
            GL11.glViewport(0, 0, Display.getWidth(), Display.getHeight());
        }
        Display.update();
    }

    public boolean canRun() {
        return !Display.isCloseRequested();
    }

    public void close() {
        Display.destroy();
    }
}

