/*
 * Decompiled with CFR 0.152.
 */
package Camera;

import Camera.Camera;
import Main.MainGameLoop;
import Physics.GraviationalObject;
import org.lwjgl.input.Mouse;
import org.lwjgl.util.vector.Vector3f;

public class ThirdPersonCamera {
    private Camera camera;
    private GraviationalObject object;
    public Vector3f rotation = new Vector3f();
    public float distanceFromObject;
    public float distanceFromObjectHold;

    public ThirdPersonCamera(Camera camera) {
        this.camera = camera;
        this.object = null;
        this.distanceFromObject = 5.0f;
        this.distanceFromObjectHold = 5.0f;
    }

    private void calculatePitchAndYaw() {
        if (Mouse.isButtonDown(0)) {
            float PI_2 = 1.5707964f;
            float dx = (float)Mouse.getDX() * 0.005f;
            float dy = (float)(-Mouse.getDY()) * 0.005f;
            this.rotation.x += dy;
            this.rotation.y += dx;
            this.rotation.x = Math.max(-PI_2, Math.min(PI_2, this.rotation.x));
        }
    }

    private void calculateNewPosition() {
        Vector3f nPos = this.object == null ? new Vector3f(0.0f, 0.0f, 0.0f) : new Vector3f(-this.object.position.x, -this.object.position.y, -this.object.position.z);
        this.camera.position.set(nPos);
        float horizontalDistance = (float)(Math.cos(-this.camera.rotation.x) * (double)this.distanceFromObject);
        float verticalDistance = (float)(Math.sin(-this.camera.rotation.x) * (double)this.distanceFromObject);
        float offsetX = (float)((double)horizontalDistance * Math.sin(-this.camera.rotation.y));
        float offsetZ = (float)((double)horizontalDistance * Math.cos(-this.camera.rotation.y));
        this.camera.position.x += -offsetX;
        this.camera.position.z += -offsetZ;
        this.camera.position.y += verticalDistance;
    }

    private Vector3f Lerp(Vector3f a, Vector3f b, float x) {
        float x1 = (b.x - a.x) * x + a.x;
        float y = (b.y - a.y) * x + a.y;
        float z = (b.z - a.z) * x + a.z;
        return new Vector3f(x1, y, z);
    }

    private float Lerp(float a, float b, float x) {
        return (b - a) * x + a;
    }

    private void calculateZoom() {
        float radius = this.object == null ? 0.0f : this.object.radius;
        float zoomLevel = (float)Mouse.getDWheel() * (this.distanceFromObjectHold - radius / 100.0f) * 0.001f;
        this.distanceFromObjectHold -= zoomLevel;
    }

    public void switchObject(GraviationalObject object1) {
        if (object1 != this.object) {
            this.object = object1;
            this.distanceFromObject = this.object.radius * 5.0f;
            this.distanceFromObjectHold = this.object.radius * 5.0f;
        }
    }

    public void update() {
        this.calculateZoom();
        this.distanceFromObject = this.Lerp(this.distanceFromObject, this.distanceFromObjectHold, 10.0f * MainGameLoop.delta_time);
        this.calculatePitchAndYaw();
        this.camera.rotation.set(this.Lerp(this.camera.rotation, this.rotation, 10.0f * MainGameLoop.delta_time));
        this.calculateNewPosition();
    }
}

