/*
 * Decompiled with CFR 0.152.
 */
package Camera;

import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector3f;

public class Camera {
    public Matrix4f projectionMatrix;
    public Matrix4f viewMatrix;
    private Matrix4f pitch;
    private Matrix4f yaw;
    private Matrix4f roll;
    private Matrix4f totalRotation;
    private Matrix4f translationMatrix;
    public Vector3f position;
    public Vector3f rotation;
    public float fov;
    public float near;
    public float far;

    public Camera(float fov, float aspectRatio, float near, float far) {
        this.fov = fov;
        this.near = near;
        this.far = far;
        this.projectionMatrix = new Matrix4f();
        this.viewMatrix = new Matrix4f();
        this.viewMatrix.setIdentity();
        this.translationMatrix = new Matrix4f();
        this.translationMatrix.setIdentity();
        this.totalRotation = new Matrix4f();
        this.rotation = new Vector3f();
        this.position = new Vector3f();
        this.pitch = new Matrix4f();
        this.yaw = new Matrix4f();
        this.roll = new Matrix4f();
        this.pitch.setIdentity();
        this.yaw.setIdentity();
        this.roll.setIdentity();
        this.updateProjectionMatrix(aspectRatio);
    }

    public void updateProjectionMatrix(float aspectRatio) {
        float y_scale = (float)(1.0 / Math.tan(Math.toRadians(this.fov / 2.0f)) * (double)aspectRatio);
        float x_scale = y_scale / aspectRatio;
        float frustum_length = this.far - this.near;
        this.projectionMatrix = new Matrix4f();
        this.projectionMatrix.m00 = x_scale;
        this.projectionMatrix.m11 = y_scale;
        this.projectionMatrix.m22 = -((this.far + this.near) / frustum_length);
        this.projectionMatrix.m23 = -1.0f;
        this.projectionMatrix.m32 = -(2.0f * this.near * this.far / frustum_length);
        this.projectionMatrix.m33 = 0.0f;
    }

    public void update() {
        this.pitch = new Matrix4f();
        this.yaw = new Matrix4f();
        this.roll = new Matrix4f();
        this.translationMatrix = new Matrix4f();
        Matrix4f.rotate(this.rotation.x, new Vector3f(1.0f, 0.0f, 0.0f), this.pitch, this.pitch);
        Matrix4f.rotate(this.rotation.y, new Vector3f(0.0f, 1.0f, 0.0f), this.yaw, this.yaw);
        Matrix4f.rotate(this.rotation.z, new Vector3f(0.0f, 0.0f, 1.0f), this.roll, this.roll);
        Matrix4f.translate(this.position, this.translationMatrix, this.translationMatrix);
        Matrix4f.mul(this.pitch, this.yaw, this.totalRotation);
        Matrix4f.mul(this.totalRotation, this.roll, this.totalRotation);
        Matrix4f.mul(this.totalRotation, this.translationMatrix, this.viewMatrix);
    }
}

